/*
********************************************************************************
*	
*   Copyright (c) 2017 by Industrial Control Communications, Inc.
*
*   This software is copyrighted by and is the sole property of
*   Industrial Control Communications, Inc.  Any unauthorized use,
*   duplication, transmission, distribution, or disclosure of this
*   software is expressly forbidden.
*
*   This Copyright notice may not be removed or modified without prior
*   written consent of Industrial Control Communications, Inc.
*
*   ICC, Inc.
*   230 Horizon Dr                      	USA 608.831.1255
*   Suite 100                               http://www.iccdesigns.com
*   Verona, WI 53593                     	support@iccdesigns.com
*
********************************************************************************
*
*          Project: SpiLinuxExample
*        File Name: SpiCommand.h
*    Original Date: 08.24.2017
*           Author: Josh Schulze
*
*      Description: Defines structures and functions used by the program
*      				to send SPI commands and receive responses.
*
*
*   Edit Date           Edit Description
*   ===============     ========================================================
*   
*
********************************************************************************
*/

#ifndef ICC_SPI_COMMAND_H
#define ICC_SPI_COMMAND_H

/*
********************************************************************************
*                                   INCLUDES
********************************************************************************
*/

#include <stdint.h>
#include <stdbool.h>
#include <linux/spi/spidev.h>

#include "IccSpiProtocol.h"
#include "SpiLinuxExample.h"

/*
********************************************************************************
*                                   TYPE DEFS
********************************************************************************
*/

typedef struct spi_command
{
	bool		managed_cmd;
	SpiCommands	command;
	uint16_t	address;
	uint32_t	value;
} SpiCommand;

/*
********************************************************************************
*                               PUBLIC PROTOTYPES
********************************************************************************
*/

int OpenSpiConnection (SpiConfig *p_spi_cfg);

int SendSpiMessage (int fd_spi, struct spi_ioc_transfer *p_spi_msg);

void SpiEncodeMessage (SpiCommand *p_spi_cmd, uint8_t *buf);

void SpiDecodeResponse (uint8_t *buf, SpiStatusReg *status_reg, uint32_t *msg_value);

void SendCommand (int fd_spi, struct spi_ioc_transfer *p_spi_msg, SpiCommand *p_spi_cmd);

#endif /* ICC_SPI_COMMAND_H */
