/*
********************************************************************************
*	
*   Copyright (c) 2017 by Industrial Control Communications, Inc.
*
*   This software is copyrighted by and is the sole property of
*   Industrial Control Communications, Inc.  Any unauthorized use,
*   duplication, transmission, distribution, or disclosure of this
*   software is expressly forbidden.
*
*   This Copyright notice may not be removed or modified without prior
*   written consent of Industrial Control Communications, Inc.
*
*   ICC, Inc.
*   230 Horizon Dr                      	USA 608.831.1255
*   Suite 100                               http://www.iccdesigns.com
*   Verona, WI 53593                     	support@iccdesigns.com
*
********************************************************************************
*
*          Project: SpiLinuxExample
*        File Name: UserIO.h
*    Original Date: 08.24.2017
*           Author: Josh Schulze
*
*      Description: Contains definitions and function prototypes for interacting
*      				with a user via command line on Linux in order to send
*      				SPI messages to a device.
*
*
*   Edit Date           Edit Description
*   ===============     ========================================================
*   
*
********************************************************************************
*/

#ifndef ICC_SPI_USER_IO_H
#define ICC_SPI_USER_IO_H

/*
********************************************************************************
*                                   INCLUDES
********************************************************************************
*/

#include <stdbool.h>

#include "SpiCommand.h"

/*
********************************************************************************
*                                    MACROS
********************************************************************************
*/

/* --- SPI Command Strings --- */
/* --- Managed SPI Commands --- */
#define SPI_SCMD_MNG_READ		"READ"
#define SPI_SCMD_MNG_WRITE		"WRITE"

/* --- ICC SPI Commands --- */
#define SPI_SCMD_GET_STATUS		"GS"
#define SPI_SCMD_SET_ADDR		"SA"
#define SPI_SCMD_READ_BYTE		"RB"
#define SPI_SCMD_READ_SHORT		"RS"
#define SPI_SCMD_READ_LONG		"RL"
#define SPI_SCMD_WRITE_BYTE		"WB"
#define SPI_SCMD_WRITE_SHORT	"WS"
#define SPI_SCMD_WRITE_LONG		"WL"

/*
********************************************************************************
*                               PUBLIC PROTOTYPES
********************************************************************************
*/

void PrintSpiPortSettings (SpiConfig *p_spi_cfg);

void PrintHelp (bool show_usage);

void PrintResults (SpiCommand *p_spi_cmd, SpiStatusReg *p_status_reg, uint32_t spi_val);

void PrintStatus (SpiStatusReg *p_status_reg);

void PrintData (SpiCommand *p_spi_cmd, SpiStatusReg *p_status_reg, uint32_t spi_val);

bool GetSpiCommandFromUser (SpiCommand *spi_cmd, bool *p_cmd_valid);

bool CanRunSpiCommand (SpiCommand *p_spi_cmd);

#endif /* ICC_SPI_USER_IO_H */
